/*
 * Decompiled with CFR 0.152.
 */
package org.blocovermelho.ae2emicrafting.client.recipes;

import appeng.core.definitions.AEBlocks;
import appeng.core.localization.ItemModText;
import appeng.recipes.transform.TransformRecipe;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.blocovermelho.ae2emicrafting.client.recipes.category.Ae2CategoryHolder;
import org.blocovermelho.ae2emicrafting.client.widget.slot.FluidBlockSlot;

public class Ae2TransformRecipe
extends BasicEmiRecipe {
    protected TransformRecipe recipe;

    public Ae2TransformRecipe(TransformRecipe source) {
        super((EmiRecipeCategory)Ae2CategoryHolder.WORLD_INTERACTION, source.method_8114(), 150, 72);
        this.recipe = source;
        this.id = source.method_8114();
        this.inputs = source.method_8117().stream().filter(x -> !x.method_8103()).map(EmiIngredient::of).toList();
        this.outputs = List.of(EmiStack.of((class_1799)source.getResultItem()));
        this.width = 150;
        this.height = 72;
    }

    public void addWidgets(WidgetHolder widgets) {
        int col1;
        int x = col1 = 10;
        int y = 10;
        int nInputs = this.recipe.method_8117().size();
        if (nInputs < 3) {
            y += 9 * (3 - nInputs);
        }
        for (EmiIngredient input : this.inputs) {
            SlotWidget slot;
            if ((y += (slot = widgets.addSlot(input, x - 1, y - 1)).getBounds().height()) >= 64) {
                y -= 54;
                x += 18;
            }
            widgets.add((Widget)slot);
        }
        int yOffset = 28;
        int col2 = col1 + 25;
        TextureWidget arrow1 = widgets.addTexture(EmiTexture.EMPTY_ARROW, col2, yOffset);
        int col3 = col2 + arrow1.getBounds().width() + 6;
        if (this.recipe.circumstance.isFluid()) {
            ingredient = EmiIngredient.of(this.recipe.circumstance.getFluidsForRendering().stream().map(EmiStack::of).toList());
            widgets.add((Widget)new FluidBlockSlot(ingredient, col3 - 1, yOffset - 1).drawBack(false));
        } else if (this.recipe.circumstance.isExplosion()) {
            ingredient = EmiIngredient.of(List.of(EmiStack.of((class_1935)AEBlocks.TINY_TNT), EmiStack.of((class_1935)class_2246.field_10375)));
            widgets.addSlot(ingredient, col3 - 1, yOffset - 1).drawBack(false);
        }
        int col4 = col3 + 16 + 5;
        TextureWidget arrow2 = widgets.addTexture(EmiTexture.EMPTY_ARROW, col4, yOffset);
        int col5 = arrow2.getBounds().right() + 10;
        widgets.addSlot((EmiIngredient)EmiStack.of((class_1799)this.recipe.getResultItem()), col5 - 1, yOffset - 1).recipeContext((EmiRecipe)this);
        class_5250 circumstanceText = this.recipe.circumstance.isExplosion() ? ItemModText.EXPLOSION.text() : ItemModText.SUBMERGE_IN.text();
        widgets.addText((class_2561)circumstanceText, this.width / 2, 15, 0x7E7E7E, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }
}

